define({"526":{i:0.000496348545956771,u:"../Content/Lua/LuaDocument/_LUA_writeStubXml.htm",a:"The writeStubXml method writes out an XML file containing the metadata for the document. The file is created in the current folder but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubXml( filename ) Arguments Argument Description filename ...",t:"writeStubXml"},"527":{i:0.000475431212245378,u:"../Content/Lua/LuaField/_LUA_LuaField_Methods.htm",a:"This section describes the methods provided by LuaField objects. A LuaField represents a single field in a document. You can retrieve LuaField objects for a document using the LuaDocument getField and getFields methods. In its simplest form a field has just a name and a value, but it can also ...",t:"LuaField Methods"},"528":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_addField.htm",a:"addField The addField method adds a sub field with the specified name and value. Syntax addField( fieldname, fieldvalue ) Arguments Argument Description fieldname (string) The name of the field. fieldvalue (string) The value of the field.",t:"addField"},"529":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_copyField.htm",a:"The copyField method copies a sub field to another sub field. If the target sub field exists it is overwritten. Syntax copyField ( from, to [, case]) Arguments Argument Description from (string) The name of the field to copy. to (string) The name of the field to copy to. case (boolean) A boolean ...",t:"copyField"},"530":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_copyFieldNoOverwrite.htm",a:"The copyFieldNoOverwrite method copies the sub field to another sub field but does not overwrite the destination. After this operation the destination field contains all the values of the source field as well as any values it already had. Syntax copyFieldNoOverwrite( from, to [, case]) Arguments ...",t:"copyFieldNoOverwrite"},"531":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_countField.htm",a:"The countField method returns the number of sub fields that exist with the specified name. Syntax countField ( fieldname [, case]) Arguments Argument Description fieldname (string) The name of the field. case (boolean) A boolean that specifies whether the fieldname argument is case sensitive. The ...",t:"countField"},"532":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_deleteAttribute.htm",a:"deleteAttribute The deleteAttribute method deletes the specified field attribute. Syntax deleteAttribute( name ) Arguments Argument Description name (string) The name of the attribute to delete.",t:"deleteAttribute"},"533":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_deleteField.htm",a:"The deleteField method deletes the sub field with the specified name. Syntax deleteField( name [, case] )  deleteField( name , value [, case] )  Arguments Argument Description name (string) The name of the sub field to delete. value (string) The value of the sub field. If this is specified a field ...",t:"deleteField"},"534":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_deleteFieldByPath.htm",a:"deleteFieldByPath The deleteFieldByPath method removes the sub field(s) with the specified path. Syntax deleteFieldByPath( path ) Arguments Argument Description path (string) The path of the sub-field(s) to delete. Example myField:deleteFieldByPath(\"path/to/subfield\")",t:"deleteFieldByPath"},"535":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_getAttributeValue.htm",a:"getAttributeValue The getAttributeValue method gets the value of the specified attribute. Syntax getAttributeValue( name ) Arguments Argument Description name (string) The name of the attribute. Returns (String). The attribute value.",t:"getAttributeValue"},"536":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_getField.htm",a:"The getField method returns the specified sub field. Syntax getField ( name [, case]) Arguments Argument Description name (string) The name of the field to return. case (boolean) A boolean that specifies whether the name argument is case sensitive. The argument is case sensitive by default (true). ...",t:"getField"},"537":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_getFieldNames.htm",a:"The getFieldNames method returns the names of the sub fields in the LuaField object. Syntax getFieldNames() Returns (Strings). The names of the sub fields. The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: fieldnames = { ...",t:"getFieldNames"},"538":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_getFields.htm",a:"The getFields method returns all of the sub fields specified by the name argument. Syntax getFields( name [, case] ) Arguments Argument Description name (string) The name of the fields. case (boolean) A boolean that specifies whether the name argument is case sensitive. The argument is case ...",t:"getFields"},"539":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_getFieldsByRegex.htm",a:"The getFieldsByRegex method returns all sub fields where the sub field name or path (relative to this field) matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Argument Description regex (string) The regular expression to match ...",t:"getFieldsByRegex"},"540":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_getFieldValues.htm",a:"The getFieldValues method returns the values of all of the sub fields with the specified name. Syntax getFieldValues( fieldname [, case] ) Arguments Argument Description fieldname (string) The name of the field. case (boolean) A boolean that specifies whether the fieldname argument is case ...",t:"getFieldValues"},"541":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_getValueByPath.htm",a:"The getValueByPath method gets the value of a sub-field, specified by path.   If you pass this method the path of a sub-field that has multiple values, only the first value is returned. To return all of the values from a multi-value sub-field, see  getValuesByPath . Syntax getValueByPath( path ) ...",t:"getValueByPath"},"542":{i:0.000909452928144173,u:"../Content/Lua/LuaField/_LUA_getValuesByPath.htm",a:"The getValuesByPath method gets the values of a sub-field, specified by path.   Syntax getValuesByPath( path ) Arguments Argument Description path (string) The path of the sub-field. Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call ...",t:"getValuesByPath"},"543":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_hasAttribute.htm",a:"hasAttribute The hasAttribute method returns a Boolean indicating whether the field has the specified attribute. Syntax hasAttribute( name ) Arguments Argument Description name (string) The name of the attribute. Returns (Boolean). A Boolean specifying if the field has the specified attribute.",t:"hasAttribute"},"544":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_hasField.htm",a:"The hasField method returns a Boolean specifying if the sub field exists. Syntax hasField( fieldname [, case]) Arguments Argument Description fieldname (string) The name of the field. case (boolean) A boolean that specifies whether the fieldname argument is case sensitive. The argument is case ...",t:"hasField"},"545":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_insertJson.htm",a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into the field. Syntax insertJson ( json [, fieldName] ) Arguments Argument Description json (string or  LuaJsonArray  or  LuaJsonObject ) The JSON to insert into the field. fieldName (string) The name of a ...",t:"insertJson"},"546":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_insertXml.htm",a:"The insertXml method inserts XML metadata into the document. When called on a LuaField, the insertXml method inserts the fields as children of the LuaField. Syntax insertXml ( node ) Arguments Argument Description node (LuaXmlNode) The node to insert. Returns (LuaField). A LuaField object of the ...",t:"insertXml"},"547":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_insertXmlWithoutRoot.htm",a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ...",t:"insertXmlWithoutRoot"},"548":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_name.htm",a:"name The name method returns the name of the field object. Syntax name() Returns (String). The name of the field object.",t:"name"},"549":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_renameField.htm",a:"The renameField method renames a sub field. Syntax renameField( oldname, newname [, case] ) Arguments Argument Description oldname (string) The previous name of the field. newname (string) The new name of the field. case (boolean) A boolean that specifies whether the oldname argument is case ...",t:"renameField"},"550":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_setAttributeValue.htm",a:"setAttributeValue The setAttributeValue method sets the value for the specified attribute of the field. Syntax setAttributeValue( attribute, value ) Arguments Argument Description attribute (string) The name of the attribute to set. value (string) The value to set.",t:"setAttributeValue"},"551":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_setValue.htm",a:"setValue The setValue method sets the value of the field. Syntax setValue( value ) Arguments Argument Description value (string) The value to set.",t:"setValue"},"552":{i:0.000491595893588945,u:"../Content/Lua/LuaField/_LUA_value.htm",a:"value The value method returns the value of the field object. Syntax value() Returns (String). The value of the field object.",t:"value"},"553":{i:0.000626201191777175,u:"../Content/Lua/LuaHttpRequest/_LUA__LuaHttpRequest.htm",a:"This section describes the methods provided by LuaHttpRequest objects. If you have a LuaHttpRequest object called request you can call its methods using the \u0027:\u0027 operator. For example: request:send() Constructor Description LuaHttpRequest:new The constructor for a LuaHttpRequest object (creates a new ...",t:"LuaHttpRequest Methods"},"554":{i:0.0005419651847069,u:"../Content/Lua/LuaHttpRequest/_LUA_LuaHttpRequest_new.htm",a:"The constructor for a LuaHttpRequest object (creates a new LuaHttpRequest). Syntax LuaHttpRequest:new( config, section ) Arguments Argument Description config (LuaConfig) The LuaConfig object that contains the settings for sending the HTTP request. To obtain a LuaConfig object, see the function  ...",t:"LuaHttpRequest:new"},"555":{i:0.000692735164238698,u:"../Content/Lua/LuaHttpRequest/_LUA_send.htm",a:"The send method sends the HTTP request. Syntax send() Returns (LuaHttpResponse). A  LuaHttpResponse  object. The send method can throw an exception if the request fails. You can catch an exception by calling the method  using the Lua function pcall. Example The following example shows how to send a ...",t:"send"},"556":{i:0.0005419651847069,u:"../Content/Lua/LuaHttpRequest/_LUA_set_body.htm",a:"set_body The set_body method sets the body of the HTTP request. Syntax set_body( body ) Arguments Argument Description body (string or nil) The body of the HTTP request.",t:"set_body"},"557":{i:0.0005419651847069,u:"../Content/Lua/LuaHttpRequest/_LUA_set_config.htm",a:"The set_config method specifies settings to use for sending the HTTP request (in the form of a section from a configuration file). For example, you can specify the proxy server to use by setting the parameters ProxyHost and ProxyPort, or specify the SSL version to use by setting SSLMethod. Syntax ...",t:"set_config"},"558":{i:0.00100263619905304,u:"../Content/Lua/LuaHttpRequest/_LUA_set_header.htm",a:"The set_header method adds a header to the HTTP request. Syntax set_header( name, value ) Arguments Argument Description name (string) The name of the HTTP header to add to the request. value (string or nil) The value of the HTTP header to add to the request. Example request:set_header(\"X-EXAMPLE\", ...",t:"set_header"},"559":{i:0.0005419651847069,u:"../Content/Lua/LuaHttpRequest/_LUA_set_headers.htm",a:"The set_headers method replaces all headers in the HTTP request with new headers. To add a header without changing existing headers, use the method  set_header . Syntax set_headers( headers ) Arguments Argument Description headers (table) The new HTTP headers to add to the request. The table must ...",t:"set_headers"},"560":{i:0.0005419651847069,u:"../Content/Lua/LuaHttpRequest/_LUA_set_method.htm",a:"set_method Specifies the HTTP request method to use when sending the request, for example GET or POST.  Syntax set_method( method ) Arguments Argument Description method (string) The HTTP request method to use. Example request:set_method(\"POST\")",t:"set_method"},"561":{i:0.0005419651847069,u:"../Content/Lua/LuaHttpRequest/_LUA_set_url.htm",a:"set_url The set_url method sets the URL that you want to send the HTTP request to. Syntax set_url( url ) Arguments Argument Description url (string) The URL to send the request to. Example request:set_url(\"https://www.example.com/\")",t:"set_url"},"562":{i:0.00106425697269452,u:"../Content/Lua/LuaHttpResponse/_LUA__LuaHttpResponse.htm",a:"This section describes the methods provided by LuaHttpResponse objects. A LuaHttpResponse object is provided when you send an HTTP request using the  send  method on a  LuaHttpRequest  object. If you have a LuaHttpResponse object called response you can call its methods using the \u0027:\u0027 operator. For ...",t:"LuaHttpResponse Methods"},"563":{i:0.000626201191777175,u:"../Content/Lua/LuaHttpResponse/_LUA_get_body.htm",a:"get_body The get_body method returns the body of the HTTP response. Syntax get_body() Returns (String). The body of the HTTP response.",t:"get_body"},"564":{i:0.000626201191777175,u:"../Content/Lua/LuaHttpResponse/_LUA_get_header.htm",a:"get_header The get_header method returns the value of a specified HTTP header. Syntax get_header( name ) Arguments Argument Description name (string) The name of the HTTP header for which you want to get the value. Returns (String). The value of the header.",t:"get_header"},"565":{i:0.000626201191777175,u:"../Content/Lua/LuaHttpResponse/_LUA_get_headers.htm",a:"The get_headers method returns the names and values of all of the headers in the HTTP response. Syntax get_headers() Returns (table) A table that maps header names to values. Example The following example sends an HTTP request and then prints the headers that are returned to the console: local ...",t:"get_headers"},"566":{i:0.000626201191777175,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found.",t:"get_http_code"},"567":{i:0.00266385858684554,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Constructor Description LuaJsonArray:new The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Method ...",t:"LuaJsonArray Methods"},"568":{i:0.000664121524587745,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Argument Description values (lua_json_type) The values to add to the array. Each value can be a Boolean, float, integer, string,  LuaJsonArray ,  LuaJsonObject ,  LuaJsonValue , or ...",t:"LuaJsonArray:new"},"569":{i:0.000664121524587745,u:"../Content/Lua/LuaJsonArray/_LUA_append.htm",a:"The append method appends a value to the JSON array. Syntax append( value ) Arguments Argument Description value (lua_json_type) The value to append to the array. This can be a  Boolean, float, integer, string,  LuaJsonArray ,  LuaJsonObject ,  LuaJsonValue , or nil. Example local myJsonArray = ...",t:"append"},"570":{i:0.000664121524587745,u:"../Content/Lua/LuaJsonArray/_LUA_clear.htm",a:"clear The clear method clears the array, so that it contains no values. Syntax clear() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:clear()\nprint (myJsonArray:string())\n-- []",t:"clear"},"571":{i:0.000664121524587745,u:"../Content/Lua/LuaJsonArray/_LUA_copy.htm",a:"The copy method returns a copy of the array. Modifying the copy does not modify the original array. Syntax copy() Returns (LuaJsonArray). A copy of the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nlocal anotherJsonArray = myJsonArray:copy()\nprint ...",t:"copy"},"572":{i:0.000664121524587745,u:"../Content/Lua/LuaJsonArray/_LUA_empty.htm",a:"The empty method checks whether the JSON array is empty. Syntax empty() Returns (Boolean). Returns true if the array is empty. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nprint (\"Is the array empty?  \" , myJsonArray:empty() )\n-- Is the array empty?   ...",t:"empty"},"573":{i:0.0044273567348887,u:"../Content/Lua/LuaJsonArray/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON array. Syntax exists( pathElements ) Arguments Argument Description pathElements (json_path_string_or_integer) The path to check. Specify one or more path elements, which might be object attribute names (strings) or array indexes ...",t:"exists"},"574":{i:0.0044273567348887,u:"../Content/Lua/LuaJsonArray/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON array. Syntax existsByPath( path ) Arguments Argument Description path (string) The path to check. Construct the path from array indexes and object attribute names, and use a slash (/) as the separator. If an object attribute ...",t:"existsByPath"},"575":{i:0.000664121524587745,u:"../Content/Lua/LuaJsonArray/_LUA_ipairs.htm",a:"The ipairs method returns a function that you can use with a for loop to iterate over all of the values in the array. Syntax ipairs() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nfor i, v in myJsonArray:ipairs() do\n  print (v:string())\nend\n\n-- prints the following...\n-- 4\n-- a ...",t:"ipairs"},"576":{i:0.0044273567348887,u:"../Content/Lua/LuaJsonArray/_LUA_lookup.htm",a:"The lookup method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookup( pathElements ) Arguments Argument Description pathElements (json_path_string_or_integer) The path of ...",t:"lookup"},"577":{i:0.0044273567348887,u:"../Content/Lua/LuaJsonArray/_LUA_lookupByPath.htm",a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookupByPath( path ) Arguments Argument Description path (string) The path of the value to return. ...",t:"lookupByPath"},"578":{i:0.000664121524587745,u:"../Content/Lua/LuaJsonArray/_LUA_size.htm",a:"size The size method returns the size of the JSON array. Syntax size() Returns (integer). The number of values in the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nprint (\"Array size is \" , myJsonArray:size() )\n-- Array size is 3",t:"size"},"579":{i:0.000664121524587745,u:"../Content/Lua/LuaJsonArray/_LUA_string.htm",a:"The string method returns the JSON array as a string. Syntax string() Returns (String). The array as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = LuaJsonArray:new(\"zero\",1,2,myJsonObject)\n\nprint (myJsonArray:string())\n-- ...",t:"string"},"580":{i:0.00266385858684554,u:"../Content/Lua/LuaJsonObject/_LUA__LuaJsonObject.htm",a:"A LuaJsonObject object represents a JSON object. If you have a LuaJsonObject object called object you can call its methods using the \u0027:\u0027 operator. For example: object:size() Constructor Description LuaJsonObject:new The constructor for a LuaJsonObject object (creates a new LuaJsonObject). Method ...",t:"LuaJsonObject Methods"},"581":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_LuaJsonObject_new.htm",a:"The constructor for a LuaJsonObject object (creates a new LuaJsonObject). If you do not specify any attributes to assign to the object (by omitting the attributes argument), an empty object is created. Syntax LuaJsonObject:new( [attributes] ) Arguments Argument Description attributes ...",t:"LuaJsonObject:new"},"582":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_assign.htm",a:"The assign method adds an attribute (a name/value pair) to the object. Syntax assign (name, value) Arguments Argument Description name (string) The name of the attribute to add. value (lua_json_type) The value of the attribute to add. This can be a Boolean, float, integer, string,  LuaJsonArray ,  ...",t:"assign"},"583":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_assign2.htm",a:"The assign method adds a table of attributes (name/value pairs) to the object. Syntax assign (attributes) Arguments Argument Description attributes (lua_json_object_type) The table of attributes to add. The keys in the table must be strings which specify the names of the attributes to add. Each ...",t:"assign"},"584":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_clear.htm",a:"clear The clear method clears the object, so that it contains no attributes (name/value pairs). Syntax clear() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:clear()\nprint (myJsonObject:string())\n-- {}",t:"clear"},"585":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_copy.htm",a:"The copy method returns a copy of the JSON object. Modifying the copy does not modify the original object. Syntax copy() Returns (LuaJsonObject). A copy of the object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal anotherJsonObject = ...",t:"copy"},"586":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_empty.htm",a:"empty The empty method determines whether the JSON object is empty. Syntax empty() Returns (Boolean). Returns true if the object has no attributes (name/value pairs). Example local myJsonObject = LuaJsonObject:new()\nprint(myJsonObject:empty())\n-- true\n",t:"empty"},"587":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_erase.htm",a:"The erase method removes a specified attribute (name/value pair) from the JSON object. Syntax erase( name ) Arguments Argument Description name (string) The name of the attribute to erase. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } ...",t:"erase"},"588":{i:0.0042476584175719,u:"../Content/Lua/LuaJsonObject/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON object. Syntax exists( pathElements ) Arguments Argument Description pathElements (json_path_string_or_integer) The path to check. Specify one or more path elements, which might be object attribute names (strings) or array indexes ...",t:"exists"},"589":{i:0.0042476584175719,u:"../Content/Lua/LuaJsonObject/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON object. Syntax existsByPath( path ) Arguments Argument Description path (string) The path to check. Construct the path from array indexes and object attribute names, and use a slash (/) as the separator. If an object ...",t:"existsByPath"},"590":{i:0.0042476584175719,u:"../Content/Lua/LuaJsonObject/_LUA_lookup.htm",a:"The lookup method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Argument Description pathElements (json_path_string_or_integer) The path ...",t:"lookup"},"591":{i:0.0042476584175719,u:"../Content/Lua/LuaJsonObject/_LUA_lookupByPath.htm",a:"The lookupByPath method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Argument Description path (string) The path of the value to return. ...",t:"lookupByPath"},"592":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_pairs.htm",a:"The pairs method returns an iterator function that you can use with a for loop to iterate over all of the attributes contained in the JSON object. Syntax pairs() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\n\nfor i, v in myJsonObject:pairs() do\n  print (i .. \u0027=\u0027 ...",t:"pairs"},"593":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_size.htm",a:"size The size method returns the number of attributes (name/value pairs) in the JSON object. Syntax size() Returns (Number). The number of attributes in the JSON object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:size())\n-- 2",t:"size"},"594":{i:0.000637165765681693,u:"../Content/Lua/LuaJsonObject/_LUA_string.htm",a:"string The string method returns the JSON object as a string. Syntax string() Returns (String). The JSON object as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\",\"version\":11}",t:"string"},"595":{i:0.00223004916004413,u:"../Content/Lua/LuaJsonValue/_LUA__LuaJsonValue.htm",a:"A LuaJsonValue object represents a JSON value.  If you have a LuaJsonValue object called myJsonValue you can call its methods using the \u0027:\u0027 operator. For example: myJsonValue:is_object() Constructor Description LuaJsonValue:new The constructor for a LuaJsonValue object (creates a new LuaJsonValue). ...",t:"LuaJsonValue Methods"},"596":{i:0.000575196747742879,u:"../Content/Lua/LuaJsonValue/_LUA_LuaJsonValue_new.htm",a:"The constructor for a LuaJsonValue object (creates a new LuaJsonValue). Syntax LuaJsonValue:new( value ) Arguments Argument Description value (lua_json_type) The initial value. This can be a  Boolean, float, integer, string,  LuaJsonArray ,  LuaJsonObject ,  LuaJsonValue , or nil. Returns ...",t:"LuaJsonValue:new"},"597":{i:0.000575196747742879,u:"../Content/Lua/LuaJsonValue/_LUA_array.htm",a:"The array method gets the array, if the value is a JSON array. Syntax array() Returns (LuaJsonArray). A  LuaJsonArray  object that represents the array. Example local fh = io.open(\"example_array.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = ...",t:"array"},"598":{i:0.000575196747742879,u:"../Content/Lua/LuaJsonValue/_LUA_copy.htm",a:"copy The copy method returns a copy of the value. Modifying the copy does not affect the original value. Syntax copy() Returns (LuaJsonValue). A copy of the value.",t:"copy"},"599":{i:0.00383454663841786,u:"../Content/Lua/LuaJsonValue/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON value. Syntax exists( pathElements ) Arguments Argument Description pathElements (json_path_string_or_integer) The path to check. Specify one or more path elements, which might be object attribute names (strings) or array indexes ...",t:"exists"},"600":{i:0.00383454663841786,u:"../Content/Lua/LuaJsonValue/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON value.  Syntax existsByPath( path ) Arguments Argument Description path (string) The path to check. Construct the path from array indexes and object attribute names, and use a slash (/) as the separator. If an object ...",t:"existsByPath"},"601":{i:0.000575196747742879,u:"../Content/Lua/LuaJsonValue/_LUA_is_array.htm",a:"is_array The is_array method whether the value is a JSON array. Syntax is_array() Returns (Boolean). Returns true if the value is an array value, false otherwise.",t:"is_array"},"602":{i:0.000575196747742879,u:"../Content/Lua/LuaJsonValue/_LUA_is_boolean.htm",a:"is_boolean The is_boolean method returns whether the value is a Boolean value. Syntax is_boolean() Returns (Boolean). Returns true if the value is a Boolean value, false otherwise.",t:"is_boolean"},"603":{i:0.000575196747742879,u:"../Content/Lua/LuaJsonValue/_LUA_is_float.htm",a:"is_float The is_float method returns whether the value is a floating point value. Syntax is_float() Returns (Boolean). Returns true if the value is a floating point value, false otherwise.",t:"is_float"},"604":{i:0.000575196747742879,u:"../Content/Lua/LuaJsonValue/_LUA_is_integer.htm",a:"is_integer The is_integer method returns whether the value is an integral value. Syntax is_integer() Returns (Boolean). Returns true if the value is an integer value, false otherwise.",t:"is_integer"},"605":{i:0.000575196747742879,u:"../Content/Lua/LuaJsonValue/_LUA_is_null.htm",a:"is_null The is_null method returns whether the value is a null value. Syntax is_null() Returns (Boolean). Returns true if the value is a null value, false otherwise.",t:"is_null"},});